<?php
require_once __DIR__ . '/../includes/config.php';

$createdBy = requireAuth();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            if (isset($_GET['id'])) {
                $stmt = $pdo->prepare("SELECT id, name, email, color, active, created_at FROM administrators WHERE id = ?");
                $stmt->execute([$_GET['id']]);
                $admin = $stmt->fetch();
                
                if ($admin) {
                    jsonResponse($admin);
                } else {
                    jsonResponse(['error' => 'Administrador não encontrado'], 404);
                }
            } else {
                $stmt = $pdo->query("SELECT id, name, email, color, active, created_at FROM administrators ORDER BY name");
                jsonResponse($stmt->fetchAll());
            }
            break;

        case 'POST':
            $data = getJsonInput();
            
            if (empty($data['name']) || empty($data['email']) || empty($data['password'])) {
                jsonResponse(['error' => 'Nome, email e senha são obrigatórios'], 400);
            }
            
            $stmt = $pdo->prepare("SELECT id FROM administrators WHERE email = ?");
            $stmt->execute([$data['email']]);
            if ($stmt->fetch()) {
                jsonResponse(['error' => 'Este email já está em uso'], 400);
            }
            
            $id = bin2hex(random_bytes(18));
            $hashedPassword = password_hash($data['password'], PASSWORD_DEFAULT);
            
            $stmt = $pdo->prepare("
                INSERT INTO administrators (id, name, email, password, color)
                VALUES (?, ?, ?, ?, ?)
            ");
            $stmt->execute([
                $id,
                $data['name'],
                $data['email'],
                $hashedPassword,
                $data['color'] ?? '#3B82F6'
            ]);
            
            jsonResponse([
                'id' => $id,
                'name' => $data['name'],
                'email' => $data['email'],
                'color' => $data['color'] ?? '#3B82F6',
                'active' => true
            ], 201);
            break;

        case 'PUT':
            $id = $_GET['id'] ?? null;
            if (!$id) {
                jsonResponse(['error' => 'ID é obrigatório'], 400);
            }
            
            $data = getJsonInput();
            
            if (empty($data['name']) || empty($data['email'])) {
                jsonResponse(['error' => 'Nome e email são obrigatórios'], 400);
            }
            
            $stmt = $pdo->prepare("SELECT id FROM administrators WHERE email = ? AND id != ?");
            $stmt->execute([$data['email'], $id]);
            if ($stmt->fetch()) {
                jsonResponse(['error' => 'Este email já está em uso'], 400);
            }
            
            if (!empty($data['password'])) {
                $hashedPassword = password_hash($data['password'], PASSWORD_DEFAULT);
                $stmt = $pdo->prepare("
                    UPDATE administrators 
                    SET name = ?, email = ?, password = ?, color = ?
                    WHERE id = ?
                ");
                $stmt->execute([
                    $data['name'],
                    $data['email'],
                    $hashedPassword,
                    $data['color'] ?? '#3B82F6',
                    $id
                ]);
            } else {
                $stmt = $pdo->prepare("
                    UPDATE administrators 
                    SET name = ?, email = ?, color = ?
                    WHERE id = ?
                ");
                $stmt->execute([
                    $data['name'],
                    $data['email'],
                    $data['color'] ?? '#3B82F6',
                    $id
                ]);
            }
            
            if ($stmt->rowCount() > 0) {
                $stmt = $pdo->prepare("SELECT id, name, email, color, active FROM administrators WHERE id = ?");
                $stmt->execute([$id]);
                jsonResponse($stmt->fetch());
            } else {
                jsonResponse(['error' => 'Administrador não encontrado'], 404);
            }
            break;

        case 'DELETE':
            $id = $_GET['id'] ?? null;
            if (!$id) {
                jsonResponse(['error' => 'ID é obrigatório'], 400);
            }
            
            if ($id === $createdBy) {
                jsonResponse(['error' => 'Você não pode excluir seu próprio usuário'], 400);
            }
            
            $stmt = $pdo->prepare("UPDATE administrators SET active = false WHERE id = ?");
            $stmt->execute([$id]);
            
            if ($stmt->rowCount() > 0) {
                jsonResponse(['success' => true]);
            } else {
                jsonResponse(['error' => 'Administrador não encontrado'], 404);
            }
            break;

        default:
            jsonResponse(['error' => 'Método não permitido'], 405);
    }
} catch (PDOException $e) {
    jsonResponse(['error' => 'Erro no banco de dados: ' . $e->getMessage()], 500);
}
