<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BURGUER DO GORDO - Controle Financeiro</title>
    
    <!-- SEO e Descrição -->
    <meta name="description" content="Sistema de Controle Financeiro do BURGUER DO GORDO. Gerencie receitas, despesas, boletos, funcionários e muito mais.">
    <meta name="author" content="BURGUER DO GORDO">
    
    <!-- Open Graph / WhatsApp / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://burguerdogordo.com.br/sistema/">
    <meta property="og:title" content="BURGUER DO GORDO - Controle Financeiro">
    <meta property="og:description" content="Sistema de Controle Financeiro do BURGUER DO GORDO. Gerencie receitas, despesas, boletos, funcionários e muito mais.">
    <meta property="og:image" content="https://burguerdogordo.com.br/sistema/assets/images/logo.jpg">
    <meta property="og:image:width" content="400">
    <meta property="og:image:height" content="400">
    <meta property="og:locale" content="pt_BR">
    <meta property="og:site_name" content="BURGUER DO GORDO">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="BURGUER DO GORDO - Controle Financeiro">
    <meta name="twitter:description" content="Sistema de Controle Financeiro do BURGUER DO GORDO. Gerencie receitas, despesas, boletos, funcionários e muito mais.">
    <meta name="twitter:image" content="https://burguerdogordo.com.br/sistema/assets/images/logo.jpg">
    
    <!-- Favicon -->
    <link rel="icon" type="image/jpeg" href="assets/images/logo.jpg">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        sidebar: {
                            DEFAULT: '#000000',
                            foreground: '#fafafa',
                            accent: '#1a1a1a',
                            border: '#1a1a1a'
                        },
                        income: '#22c55e',
                        expense: '#ef4444'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-50 dark:bg-zinc-900 font-[Inter] min-h-screen">
    <!-- Login Screen -->
    <div id="login-screen" class="fixed inset-0 z-[100] bg-black flex items-center justify-center">
        <div class="w-full max-w-md p-8">
            <div class="text-center mb-8">
                <img src="assets/images/logo.jpg" alt="Burguer do Gordo" class="w-40 h-40 mx-auto mb-4 object-contain">
                <p class="text-gray-400">Controle Financeiro</p>
            </div>
            <form id="login-form" class="bg-zinc-900 rounded-lg shadow-lg p-6 space-y-4 border border-zinc-800">
                <div id="login-error" class="hidden bg-red-900/30 text-red-400 p-3 rounded-md text-sm"></div>
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-1">Email</label>
                    <input type="email" id="login-email" required class="w-full px-3 py-2 border border-zinc-700 rounded-md bg-zinc-800 text-white focus:ring-2 focus:ring-white focus:border-transparent" data-testid="input-login-email" placeholder="admin@burguer.com">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-1">Senha</label>
                    <input type="password" id="login-password" required class="w-full px-3 py-2 border border-zinc-700 rounded-md bg-zinc-800 text-white focus:ring-2 focus:ring-white focus:border-transparent" data-testid="input-login-password" placeholder="••••••••">
                </div>
                <button type="submit" class="w-full bg-white hover:bg-gray-200 text-black font-medium py-2 px-4 rounded-md transition-colors" data-testid="button-login">
                    Entrar
                </button>
            </form>
        </div>
    </div>

    <div id="app-container" class="flex h-screen hidden">
        <!-- Sidebar -->
        <aside id="sidebar" class="fixed lg:static inset-y-0 left-0 z-50 w-64 bg-sidebar text-sidebar-foreground transform -translate-x-full lg:translate-x-0 transition-transform duration-200 ease-in-out flex flex-col">
            <!-- Logo -->
            <div class="p-4 border-b border-sidebar-border">
                <div class="flex items-center justify-center">
                    <img src="assets/images/logo.jpg" alt="Burguer do Gordo" class="h-16 object-contain">
                </div>
            </div>
            
            <!-- User Info -->
            <div class="p-4 border-b border-sidebar-border">
                <div class="flex items-center gap-3">
                    <div id="user-avatar" class="w-8 h-8 rounded-full flex items-center justify-center text-white text-sm font-medium" style="background-color: #3B82F6;">A</div>
                    <div class="flex-1 min-w-0">
                        <p id="user-name" class="text-sm font-medium truncate">Administrador</p>
                        <p id="user-email" class="text-xs text-gray-400 truncate">admin@burguer.com</p>
                    </div>
                    <button onclick="logout()" class="p-1.5 rounded-md hover:bg-sidebar-accent transition-colors" title="Sair" data-testid="button-logout">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/></svg>
                    </button>
                </div>
            </div>
            
            <!-- Navigation -->
            <nav class="flex-1 p-4 space-y-1 overflow-y-auto">
                <p class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">Principal</p>
                <a href="#" onclick="loadPage('dashboard')" data-page="dashboard" class="nav-link flex items-center gap-3 px-3 py-2 rounded-md hover:bg-sidebar-accent transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/></svg>
                    <span>Dashboard</span>
                </a>
                <a href="#" onclick="loadPage('transactions')" data-page="transactions" class="nav-link flex items-center gap-3 px-3 py-2 rounded-md hover:bg-sidebar-accent transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                    <span>Lançamentos</span>
                </a>
                <a href="#" onclick="loadPage('bills')" data-page="bills" class="nav-link flex items-center gap-3 px-3 py-2 rounded-md hover:bg-sidebar-accent transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
                    <span>Boletos</span>
                </a>
                <a href="#" onclick="loadPage('projections')" data-page="projections" class="nav-link flex items-center gap-3 px-3 py-2 rounded-md hover:bg-sidebar-accent transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/></svg>
                    <span>Projeções</span>
                </a>
                <a href="#" onclick="loadPage('calendar')" data-page="calendar" class="nav-link flex items-center gap-3 px-3 py-2 rounded-md hover:bg-sidebar-accent transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                    <span>Agenda</span>
                </a>
                
                <p class="text-xs font-semibold text-gray-500 uppercase tracking-wider mt-6 mb-2">Recursos Humanos</p>
                <a href="#" onclick="loadPage('employees')" data-page="employees" class="nav-link flex items-center gap-3 px-3 py-2 rounded-md hover:bg-sidebar-accent transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg>
                    <span>Funcionários</span>
                </a>
                <a href="#" onclick="loadPage('salaries')" data-page="salaries" class="nav-link flex items-center gap-3 px-3 py-2 rounded-md hover:bg-sidebar-accent transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"/></svg>
                    <span>Salários</span>
                </a>
                <a href="#" onclick="loadPage('absences')" data-page="absences" class="nav-link flex items-center gap-3 px-3 py-2 rounded-md hover:bg-sidebar-accent transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                    <span>Faltas</span>
                </a>
                
                <p class="text-xs font-semibold text-gray-500 uppercase tracking-wider mt-6 mb-2">Cadastros</p>
                <a href="#" onclick="loadPage('partners')" data-page="partners" class="nav-link flex items-center gap-3 px-3 py-2 rounded-md hover:bg-sidebar-accent transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/></svg>
                    <span>Parceiros</span>
                </a>
                <a href="#" onclick="loadPage('branches')" data-page="branches" class="nav-link flex items-center gap-3 px-3 py-2 rounded-md hover:bg-sidebar-accent transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/></svg>
                    <span>Filiais</span>
                </a>
                <a href="#" onclick="loadPage('administrators')" data-page="administrators" class="nav-link flex items-center gap-3 px-3 py-2 rounded-md hover:bg-sidebar-accent transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/></svg>
                    <span>Administradores</span>
                </a>
            </nav>
        </aside>

        <!-- Overlay for mobile -->
        <div id="sidebar-overlay" class="fixed inset-0 bg-black/50 z-40 hidden lg:hidden" onclick="toggleSidebar()"></div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col min-h-screen overflow-hidden">
            <!-- Header -->
            <header class="h-14 border-b border-gray-200 dark:border-zinc-700 bg-white dark:bg-zinc-800 flex items-center justify-between px-4">
                <button onclick="toggleSidebar()" class="lg:hidden p-2 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-700" data-testid="button-sidebar-toggle">
                    <svg class="w-6 h-6 text-gray-600 dark:text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/></svg>
                </button>
                <h2 id="page-title" class="text-lg font-semibold text-gray-800 dark:text-white" data-testid="text-page-title">Dashboard</h2>
                <button onclick="toggleTheme()" class="p-2 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-700" data-testid="button-theme-toggle">
                    <svg id="theme-icon-light" class="w-5 h-5 text-gray-600 dark:hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"/></svg>
                    <svg id="theme-icon-dark" class="w-5 h-5 text-gray-300 hidden dark:block" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"/></svg>
                </button>
            </header>

            <!-- Page Content -->
            <main id="main-content" class="flex-1 overflow-auto p-4 md:p-6">
                <!-- Content will be loaded here -->
            </main>
        </div>
    </div>

    <!-- Modal Container -->
    <div id="modal-container" class="fixed inset-0 z-50 hidden">
        <div class="fixed inset-0 bg-black/50" onclick="closeModal()"></div>
        <div class="fixed inset-0 flex items-center justify-center p-4 pointer-events-none">
            <div id="modal-content" class="bg-white dark:bg-zinc-800 rounded-lg shadow-xl w-full max-h-[90vh] overflow-auto pointer-events-auto" style="max-width: 38rem;">
                <!-- Modal content will be injected here -->
            </div>
        </div>
    </div>

    <script src="assets/js/app.js"></script>
    <script src="assets/js/pages/dashboard.js"></script>
    <script src="assets/js/pages/transactions.js"></script>
    <script src="assets/js/pages/bills.js"></script>
    <script src="assets/js/pages/projections.js"></script>
    <script src="assets/js/pages/partners.js"></script>
    <script src="assets/js/pages/branches.js"></script>
    <script src="assets/js/pages/employees.js"></script>
    <script src="assets/js/pages/salaries.js"></script>
    <script src="assets/js/pages/administrators.js"></script>
    <script src="assets/js/pages/calendar.js"></script>
    <script src="assets/js/pages/absences.js"></script>
    <script>
        // Initialize app
        document.addEventListener('DOMContentLoaded', () => {
            initTheme();
            checkAuth();
        });
    </script>
</body>
</html>
