<?php
// Router file for PHP built-in server
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

// Serve static files
if (preg_match('/\.(?:css|js|png|jpg|jpeg|gif|ico|svg|woff|woff2|ttf|eot)$/i', $uri)) {
    return false;
}

// API routes
if (strpos($uri, '/api/') === 0) {
    $endpoint = substr($uri, 5); // Remove '/api/'
    $file = __DIR__ . '/api/' . $endpoint;
    if (file_exists($file)) {
        require $file;
        return true;
    }
    http_response_code(404);
    echo json_encode(['error' => 'API endpoint not found']);
    return true;
}

// Default to index.php
require __DIR__ . '/index.php';
